/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.Device;
import ibm.nways.jdm.IdentificationService;
import ibm.nways.jdm.NMPlatformDBInterface;
import ibm.nways.jdm.OvDBFieldValue;
import ibm.nways.jdm.OvObjectListHandlerInterface;
import ibm.nways.jdm.SnmpSecurityInfo;
import java.io.Serializable;

public class JdmDevice
implements Device,
Cloneable,
Serializable {
    private int objectId;
    private NMPlatformDBInterface nmplatformdb;
    private OvObjectListHandlerInterface idServer;

    public int getToken() {
        return this.objectId;
    }

    protected void setToken(int n) {
        this.objectId = n;
    }

    public JdmDevice(int n, OvObjectListHandlerInterface ovObjectListHandlerInterface, NMPlatformDBInterface nMPlatformDBInterface) {
        this.objectId = n;
        this.nmplatformdb = nMPlatformDBInterface;
        this.idServer = ovObjectListHandlerInterface;
    }

    public Object getAddress() {
        String string = null;
        try {
            string = this.nmplatformdb.getIPAddress(this.objectId);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void setAddress(Object object) {
    }

    public String getHostName() {
        String string = null;
        try {
            OvDBFieldValue ovDBFieldValue = this.nmplatformdb.getFieldValue(this.objectId, "IP Hostname");
            string = ovDBFieldValue.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public int getAddressType() {
        return 1;
    }

    public void setAddressType(int n) {
    }

    public String getName() {
        String string = null;
        try {
            string = this.nmplatformdb.getIPAddress(this.objectId);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void setName(String string) {
    }

    public Object getDeviceType() {
        String string = null;
        try {
            string = this.nmplatformdb.getSysOid(this.objectId);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void setDeviceType(Object object) {
    }

    public int getProtocol(int n) {
        return 1;
    }

    public void setProtocol(int n, int n2) {
    }

    public Object getSecurityInfo() {
        SnmpSecurityInfo snmpSecurityInfo = null;
        try {
            SnmpSecurityInfo snmpSecurityInfo2;
            String string = this.nmplatformdb.getCommunityName(this.objectId);
            String string2 = this.nmplatformdb.getWriteCommunityName(this.objectId);
            snmpSecurityInfo = snmpSecurityInfo2 = new SnmpSecurityInfo(this.objectId, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return snmpSecurityInfo;
    }

    public void setSecurityInfo(Object object) {
        if (object instanceof SnmpSecurityInfo) {
            try {
                SnmpSecurityInfo snmpSecurityInfo = (SnmpSecurityInfo)object;
                String string = snmpSecurityInfo.getReadCommunityName();
                String string2 = snmpSecurityInfo.getWriteCommunityName();
                this.nmplatformdb.setCommunityName(this.objectId, string);
                this.nmplatformdb.setWriteCommunityName(this.objectId, string2);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public IdentificationService getIdentificationServer() {
        return this.idServer;
    }

    public void setIdentificationServer(IdentificationService identificationService) {
        this.idServer = (OvObjectListHandlerInterface)identificationService;
    }

    public NMPlatformDBInterface getPlatformDBServer() {
        return this.nmplatformdb;
    }

    public void setPlatformDBServer(NMPlatformDBInterface nMPlatformDBInterface) {
        this.nmplatformdb = nMPlatformDBInterface;
    }
}

